<?php
class ScoutnetKalenderClass {

  /**
   * Bevor die Seite angezeigt wird (Hooks => BeforePageDisplay):
   * JavaScript-Dateien und Inline-Skript laden
   *
   * @param  object  &$out  OutputPage Objekt
   * @param  object  &$sk   Skin Objekt, das für diese Seite verwendet werden soll
   */
  public function SNKParserFunction_Head(&$out, &$sk) {
    $out -> addInlineScript('$(document).ready(function() {$(".snk-termin-infos").hide();});'); // Alle Details nach dem Laden der Seite verbergen (Mit Klick zu öffnen)
    return true;
  }


  /**
   * Magische Worte definieren (Hooks => LanguageGetMagic)
   * siehe Handbuch: https://www.mediawiki.org/wiki/Manual:Magic_words/de
   *
   * @param  array   &$magicWords    Magische Worte
   * @param  string  $langCode       Code der verwendeten Sprache (Anm.: Hier wird nicht zwischen einzelnen Sprachen unterschieden)
   *
   * @magicWords  #snk
   * @magicWords  #snk_openInfo      Link zu Javascript für Anzeige/Verbergen der Detailinfos ausgeben (Verwendung normalerweise nur von diesem Skript)
   * @magicWords  #snk_addSSIDForm   Formular für die Auswahl weiterer Kalender anzeigen (Verwendung normalerweise nur von diesem Skript)
   */
  public function SNKParserFunction_Magic(&$magicWords, $langCode) {
    // Das erste Element dieses Arrays ist ein Integer-Flag, das kennzeichnet, ob das Magische Wort groß-klein-empfindlich ist.
    // Ist das Flag 0 werden alle Variationen aus Klein- und Grossbuchstaben erkannt.
    // Die weiteren Elemente sind eine Textliste, die mit der ID des Magischen Wortes verknüpft sein sollen.
    $magicWords["snk"]             = array( 0, "snk" );
    $magicWords["snk_openInfo"]    = array( 0, "snk_openInfo" );
    $magicWords["snk_addSSIDForm"] = array( 0, "snk_addSSIDForm" );
    // unless we return true, other parser functions extensions won't get loaded.
    return true;
  }


  /**************************************************************************************************************************/

  /**
   * Funktion, die aufgerufen wird, nachdem die MediaWiki Initialisierung fast komplett ist:
   * Parser-Hooks setzen
   */
  public function SNKParserFunction_Setup() {
    global $wgParser;
    $wgParser->setFunctionHook( "snk",             "ScoutnetKalenderClass::SNKParserFunction_Render" );
    $wgParser->setFunctionHook( "snk_openInfo",    "ScoutnetKalenderClass::SNKParserFunction_OpenInfo" );
    $wgParser->setFunctionHook( "snk_addSSIDForm", "ScoutnetKalenderClass::SNKParserFunction_addSSIDForm" );
  }


  /**
   * Link zu Javascript für Anzeige/Verbergen der Detailinfos ausgeben
   *
   * Beim Klick auf den Link werden die Detailinfos angezeigt und das Icon hinter dem Text geändert
   *
   * Voraussetzung:
   * Die Detailinfos müssen die HTML Class="snk_termin-$id" haben. ($id durch jeweilige Event-ID ersetzen)
   *
   * @param  object   &$parser
   * @param  integer  $id        ID dieses Events
   * @param  string   $value     Anzuzeigender Text für den Link
   */
  public function SNKParserFunction_OpenInfo(&$parser, $id = "", $value = "") {
    $text = '<a href="#snk_termin-' . $id . '" class="snk-termin-link" onclick="$(\'#snk-termin-' . $id . '\').toggle(); $(\'#snk-link-' . $id . '\').html( ($(\'#snk-link-' . $id . '\').text() == \'&#8689;\') ? \'&#8690;\' : \'&#8689;\');">' . $value . ' <span id="snk-link-' . $id . '">&#8690;</span></a>';
    return array($text, "isHTML" => true);
  }


  /**
   * Auswahl-Formular für die in der SSID-Liste zusätzlich angegebenen Kalender anzeigen
   *
   * @param  object  &$parser
   * @param  array   $ssids     Liste weiterer Kalender-SSIDs
   */
  public function SNKParserFunction_addSSIDForm( &$parser, $ssids = "") {
    global $wgRequest;
    $text = 'Zeige auch diese Kalender an:<br><form action="#" method="get">';
    $SN   = new jsonRPCClient("https://www.scoutnet.de/jsonrpc/server.php");
    $res  = $SN->get_data_by_global_id(explode(",", $ssids), array("kalenders" => array()));

    // Bestehende GET-Parameter übernehmen (v.a. für Wiki mit "?title=SEITENNAME" nötig)
    $text .= '<input type="hidden" name="title" value="' . $wgRequest -> getVal("title") . '">';
    // @ToDo: Prüfen, ob auch weitere _GET-Parameter eingebunden werden müssen.
    // ACHTUNG: Crossite Skripting !
    #foreach ($wgRequest as $gk => $gv) {
    #  if ($gk != "addIds") $text .= '<input type="hidden" name="' . $gk . '" value="' . $gv . '">';
    #}

    foreach ($res as $record) {
      if ($record["type"] == "kalender") {
        $kalender = $record["content"];
        $ssid     = $kalender["ID"];
        $text    .= '<input onchange="form.submit();" type="checkbox" id="kalender_' . $ssid . '" name="addIds[' . $ssid . ']" value="' . $ssid . '"' . (!empty($_GET["addIds"][$ssid]) && $_GET["addIds"][$ssid] === $ssid ? " checked " : "") . '>&nbsp;<label for="kalender_' . $ssid . '">' . $kalender["Ident"] . "</label>" . PHP_EOL;
      }
    }

    // Nur wenn JavaScript nicht verfügbar ist einen "Anzeigen"-Button zum Absenden darstellen
    $text .= '<input type="submit" value="Anzeigen" id="snd_anzeigen"></form><script>$("#snd_anzeigen").hide();</script>';
    return array($text, "isHTML" => true);
  }


  /**
   * Kalender ausgeben
   *
   * @param  object   &$parser
   * @param  integer  $ssid       Liste der anzuzeigenden SSIDs (Komma getrennt)
   * @param  integer  $limit      Maximale Anzahl anzuzeigender Events  (Standard: 10)
   * @param  array    $addssid    IDs der zusätzlich anzuzeigenden Kalender
   */
  public function SNKParserFunction_Render(&$parser, $ssid = "17", $limit = 10, $addssid = "") {
    $parser -> disableCache();

    // Standardwert für maximale Anzahl anzuzeigender Events setzen
    if (!is_numeric($limit)) $limit = 10;

    // Initialisierung
    $current_month = "";
    $kalenderArray = Array();
    $stufenArray   = Array();

    $ssids = explode(",", $ssid);

    // Zusätzlich anzuzeigende Kalender-IDs aus der URL übernehmen
    if (isset($_GET["addIds"])) {
      foreach ($_GET["addIds"] as $addid) {
        if (is_numeric($addid)) $ssids[] = intval($addid);
      }
    }

    // Events-Objekt vom ScoutNet-Kalender einlesen
    $filter = array("events" => array("limit" => $limit, "after" => "now()"));
    $SN     = new jsonRPCClient("https://www.scoutnet.de/jsonrpc/server.php");
    $res    = $SN -> get_data_by_global_id($ssids, $filter);
    $text   = "";
    // Checkboxen für weitere Kalender ausgeben (s.o. Funktion "SNKParserFunction_addSSIDForm")
    if ($addssid) {
      $text .= "{{ #snk_addSSIDForm: $addssid}}" . PHP_EOL;
    }

    // Events als Tabelle ausgeben (Fünf Spalten)
    if (!empty($res) && @$res[0]["content"] != "noMatch") {  // Nur ausgeben, wenn es Events gibt
      $text .= '{| class="wikitable"' . PHP_EOL;
      foreach ($res as $record) {
        if ($record["type"] === "event") {
          $line = $record["content"];

          if ($current_month != gmstrftime("%B '%y", $line["Start"])) {
            $text .= "|-" . PHP_EOL;
            $text .= "! colspan=\"5\" |'''" . gmstrftime("%B '%y", $line["Start"]) . "''':" . PHP_EOL; // Definition fest auf 5 Spalten, Überschrift: Monat und 'Jahr
            $text .= "|-" . PHP_EOL;
            $current_month = gmstrftime("%B '%y", $line["Start"]);
          }

          $text .= "{{snk_termin";  // Spezielle Wiki-Vorlage nötig: snk_termin
          foreach ($line as $key => $value) {
            $text .= "|" . strtolower($key) . "=";
            switch ($key) {
              case "Title":
                if (!empty($line["Description"] . $line["ZIP"] . $line["Location"] . $line["Organizer"] . $line["Target_Group"] . $line["URL_Text"] . $line["URL"])) {
                  $text .= "{{ #snk_openInfo: " . $line["ID"] . "|$value}}";
                } else {
                  $text .= $value;
                }
                break;
              case "Stufen":  // Spezielle Wiki-Vorlage nötig: snk_stufe
                if (!is_array($value)) {
                  $value= array($value);
                }
                foreach ($value as $st_key => $st_val) {
                  $text .= "{{snk_stufe";
                  foreach ($stufenArray[$st_val] as $kal_key => $kal_value) {
                    if ($kal_value == "Ranger/Rover") $kal_value = "Ranger & Rover"; // Problem für VCP mit Schrägstrich in der Bezeichnung lösen
                    $text .= "|" . strtolower($kal_key) . "=" . $kal_value;
                  }
                  $text .= "}}";
                }
                break;
              case "Keywords":  // Spezielle Wiki-Vorlage nötig: snk_keyword
                if (!is_array($value)) {
                  $value = array($value);
                }
                $last = end($value); // Wert des letzten Elements merken
                // Aufzählung aller Keywords bzw. Tags dieses Events
                foreach ($value as $st_key => $st_val) {
                  $text .= "{{snk_keyword|id=" . $st_key . "|value=" . trim($st_val) . "}}";
                  if ($last != $st_val) { // Nach dem letzten Element kein Komma einfügen
                    $text .= ", ";
                  }
                }
                break;
              case "Start":
              case "End":
                $text .= gmstrftime("%a,&nbsp;%d.%m", $value) . ($line["All_Day"] ? "" : " " . gmstrftime("%H:%M", $value) . "&nbsp;Uhr");
                break;
              case "Kalender":  // Spezielle Wiki-Vorlage nötig
                $text .= "{{snk_kalender";
                foreach ($kalenderArray[$value] as $kal_key => $kal_value) {
                  if (!is_array($kal_value)) $text .= "|" . strtolower($kal_key) . "=" . $kal_value;
                }
                $text .= "}}";
                break;
              case "URL":
                if (substr($value, 0, 4) == "http" || strpos($value, ":") !== FALSE) $text .= $value;
                elseif (!empty($value)) $text .= "http://" . $value; // wenn in der URL das Protokoll fehlt, dann "http" ergänzen
                break;
              case "URL_Text":
                  if (empty($value)) $text .= $line["URL"]; // Wenn kein URL-Text angegeben ist, stattdessen URL anzeigen
                  else $text .= $value;
                break;
              default:
                if (!empty($value)) $text .= $value;
                break;
            }
          }

          $text .= "|zeit = " . gmstrftime("%a,&nbsp;%d.%m", $line["Start"]) . ($line["All_Day"] ? "" : " " . gmstrftime("%H:%M", $line["Start"]) . "&nbsp;Uhr");
          if ($line["Start"] != $line["End"]) {
            $text .= "&nbsp;- " . (gmstrftime("%d.%m", $line["Start"]) == gmstrftime("%d.%m", $line["End"]) ? "" : gmstrftime("%a,&nbsp;%d.%m", $line["End"])) .
                     ($line["All_Day"] ? "" : " " . gmstrftime("%H:%M", $line["End"]) . "&nbsp;Uhr");
          }
          $text .= "}}" . PHP_EOL;

        } else if ($record["type"] == "kalender") {
          $kalenderArray[$record["content"]["ID"]]        = $record["content"];
        } else if ($record["type"] == "stufe") {
          $stufenArray[$record["content"]["Keywords_ID"]] = $record["content"];
        }

        $text .= "|-" . PHP_EOL;  // Neue Zeile beginnen
      }
      $text .= "|}";
    } else {
      $text .= "Keine aktuellen Termine" . PHP_EOL;
    }

    return array($text, "noparse" => false);
  }
}
?>